/*---------------------------------------------*\
|  Servo Driver					|
|  Contains functions used to drive ATMega328	|
|  Servo Driver and Arduino Vex Robot Controller|
\*---------------------------------------------*/

#include <stdio.h>
#include <iostream>
#include <unistd.h>
#include <fcntl.h>
#include <termios.h>
#include <string>

using namespace std;
//Serial Port Open
//Opens the serial port specified by 'dev'
//Set Baud Rate with stty
//Returns file descriptor if successful
//Returns -1 if unsuccessful
int serialOpen(string dev);

//Update Servo
//Updates the servo's position
//Must specify the file descriptor of the port that the servo controller
//is connected to
void updateServo(char position, int port);

//Update Vex
//Updates the Arduino Vex platform's two main motors
//Must specify the file descriptor of the port that the AVR/Arduino Vex
//motor controller is connected to
void updateVex(char motor1, char motor2, int port);

//Get Speed Limit
//Returns speed limits m1 and m2
//Requires the Arduino to be running the version that supports speed limit feedback
char* get_speed_limit(int port);

//Set Speed Limit
//Sets speed limits m1 and m2 to Arduino
void set_speed_limit(char m1, char m2, int port);
